%%
%% This is file `stm.cls',
%%
%% This file is part of the 'Stm Bundle'.
%% ..........................................-
%% 
%% It may be distributed under the conditions of the LaTeX Project Public
%% License, either version 1.2 of this license or (at your option) any
%% later version.  The latest version of this license is in
%%    http://www.latex-project.org/lppl.txt
%% and version 1.2 or later is part of all distributions of LaTeX
%% version 1999/12/01 or later.
%% 
%% The list of all files belonging to the 'Stm Bundle' is
%% given in the file `manifest.txt'.
%% 
%%
%% 
%% $Id: stm.cls 11 2013-01-25 08:55:15Z cvr $
%% $Author: cvr $
%% $URL: http://redmine.sayahna.org/svn/stm/stm.cls $
%% $LastChangedDate: 2013-01-25 14:25:15 +0530 (Fri, 25 Jan 2013) $
%%
 \def\RCSfile{stm}%
 \def\RCSversion{1.0}%
 \def\RCSdate{2013/01/20}%
 \def\@journal{Sayahna}
 \def\@shortjid{stm}
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{\@shortjid}[\RCSdate, \RCSversion: \@journal]
%
\def\ABD{\AtBeginDocument}
 \def\@shortjnl{\relax}
 \def\@company{Sayahna Foundation}
 \def\@issn{000-0000}

%
% switches
% 
\newif\ifpreprint       \preprintfalse
%DW \newif\ifnonatbib       \nonatbibfalse
\newif\iflongmktitle    \longmktitlefalse
\newif\ifnopreprintline \nopreprintlinefalse
\@ifundefined{ifhtml}{\newif\ifhtml\htmlfalse}{}
\newif\if@stm      \@stmfalse
\newif\if@screen   \@screenfalse
\newif\if@biblatex \@biblatexfalse
\newif\if@debug    \@debugfalse
\newif\if@qlinks   \@qlinksfalse
\newif\if@doc      \@docfalse
\newif\if@noenum   \@noenumfalse
\newif\if@gray     \@grayfalse
\newif\ifsecondpass

\newcounter{jfont}
\setcounter{jfont}{0}
\let\ifscreen\if@screen
\let\ifdoc\if@doc

\def\blstr#1{\gdef\@blstr{#1}}
\def\@blstr{1}
\newdimen\@bls
\@bls=\baselineskip

\DeclareOption{preprint}{\global\preprinttrue
  \gdef\@blstr{1}\xdef\jtype{0}%
  \AtBeginDocument{\@twosidefalse\@mparswitchfalse}}
\DeclareOption{nopreprintline}{\global\nopreprintlinetrue}
\DeclareOption{final}{\gdef\@blstr{1}\global\preprintfalse
  \AtBeginDocument{\@twosidetrue\@mparswitchtrue}}
\DeclareOption{review}{\global\preprinttrue\gdef\@blstr{1.5}}
\DeclareOption{authoryear}{\xdef\@biboptions{round,authoryear}}
\DeclareOption{number}{\xdef\@biboptions{numbers}}
\DeclareOption{numbers}{\xdef\@biboptions{numbers}}
%DW \DeclareOption{nonatbib}{\global\nonatbibtrue}
\DeclareOption{longtitle}{\global\longmktitletrue}
\DeclareOption{html}{\global\htmltrue}
\DeclareOption{stm}{\global\@stmtrue}
\DeclareOption{gray}{\global\@graytrue}

\DeclareOption{screen}{\xdef\jtype{6}%
  \global\preprintfalse\global\@screentrue}

\DeclareOption{doc}{\xdef\jtype{7}%
  \global\preprintfalse\global\@doctrue}

\DeclareOption{5p}{\xdef\jtype{5}\global\preprintfalse
  \AtBeginDocument{\@twosidetrue\@mparswitchtrue}
  \ExecuteOptions{twocolumn}}
\def\jtype{0}

\DeclareOption{wide}{\ExecuteOptions{5p}}
\DeclareOption{3p}{\xdef\jtype{3}\global\preprintfalse
  \AtBeginDocument{\@twosidetrue\@mparswitchtrue}}
\DeclareOption{standard}{\ExecuteOptions{3p}}

\DeclareOption{1p}{\xdef\jtype{1}\global\preprintfalse
  \AtBeginDocument{\@twosidetrue\@mparswitchtrue}}

\DeclareOption{narrow}{\ExecuteOptions{1p}}
\DeclareOption{color}{\AtEndOfClass{\@LoadXcolor}}

\DeclareOption{cmr}{\setcounter{jfont}{0}}
\DeclareOption{antt}{\setcounter{jfont}{1}}
\DeclareOption{arev}{\setcounter{jfont}{2}}
\DeclareOption{charter}{\setcounter{jfont}{3}}
\DeclareOption{fouriernc}{\setcounter{jfont}{4}}
\DeclareOption{fourier}{\setcounter{jfont}{5}}
\DeclareOption{garamond}{\setcounter{jfont}{6}}
\DeclareOption{kerkis}{\setcounter{jfont}{7}}
\DeclareOption{kurier}{\setcounter{jfont}{8}}
\DeclareOption{mathpazo}{\setcounter{jfont}{9}}
\DeclareOption{mathpple}{\setcounter{jfont}{10}}
\DeclareOption{palatino}{\setcounter{jfont}{11}}
\DeclareOption{sspro}{\setcounter{jfont}{12}}
\DeclareOption{times}{\setcounter{jfont}{13}}
\DeclareOption{utopia}{\setcounter{jfont}{14}}

% \DeclareOption{}{\setcounter{jfont}{0}}
% \DeclareOption{}{\setcounter{jfont}{0}}
% \DeclareOption{}{\setcounter{jfont}{0}}
% \DeclareOption{}{\setcounter{jfont}{0}}
% \DeclareOption{}{\setcounter{jfont}{0}}
% \DeclareOption{}{\setcounter{jfont}{0}}

\DeclareOption{endfloat}{\IfFileExists{endfloat.sty}
  {\AtEndOfClass{\RequirePackage[markers]{endfloat}}}{}}
\DeclareOption{endfloats}{\IfFileExists{endfloat.sty}
  {\AtEndOfClass{\RequirePackage[markers]{endfloat}}}{}}
\DeclareOption{numafflabel}%
  {\AtBeginDocument{\def\theaffn{\arabic{affn}}}}
\DeclareOption{lefttitle}%
   {\AtBeginDocument{\def\stmtitlealign{flushleft}}} %*%
\DeclareOption{centertitle}%
   {\AtBeginDocument{\def\stmtitlealign{center}}} %*%
\DeclareOption{reversenotenum}%
   {\AtBeginDocument{\def\theaffn{\arabic{affn}}%
       \def\thefnote{\alph{fnote}}}}
\DeclareOption{debug}{\global\@debugtrue}
\DeclareOption{qlinks}{\global\@qlinkstrue}
\DeclareOption{noenum}{\global\@noenumtrue}

\ExecuteOptions{a4paper,10pt,oneside,onecolumn,number,preprint,cmr,centertitle}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass{article}
\RequirePackage{graphicx}
\RequirePackage{amsfonts,amssymb,xspace}

\def\@LoadXcolor{\RequirePackage[dvipsnames,svgnames]{xcolor}}
\ifnum\jtype<6
 \@ifundefined{colorlet}{\let\colorlet\@gobbletwo}{}
\fi
\let\comma\@empty
\let\tnotesep\@empty
\let\@title\@empty
\def\usestmtitle{}
\if@debug
  \def\alarm#1{%
    \typeout{......................................................}%
    \typeout{#1}%
    \typeout{......................................................}%
  }%
  \else\let\alarm\@gobble
\fi

\def\title#1{\g@addto@macro\@title{#1%
    \global\let\tnoteref\@gobble%
    \@ifundefined{mark@title}{\ignorespaces}%
    {\xdef\@tmp{\@nameuse{mark@title}}%
      \@for\p@mark:=\@tmp\do
      {\textsuperscript{\ifcase\p@mark\or$\star$\or
          \unskip,$\star\star$\fi}%
      }%
    }%
  }%
  \g@addto@macro\usestmtitle{#1}%
}

\def\stmLabel#1{\@bsphack\protected@write\@auxout{}%
         {\string\Newlabel{#1}{\@currentlabel}}\@esphack}
\def\Newlabel#1#2{\expandafter\xdef\csname X@#1\endcsname{#2}}
\def\writemarks#1#2{\immediate\write\@auxout{
    \string\expandafter\string\gdef\string\csname\space
      mark@#1\string\endcsname{#2}}}

\def\stmRef#1{\@ifundefined{X@#1}{0}{\csname X@#1\endcsname}}

\let\@tnotemark\@empty

\def\tnoteref#1{\@for\mytmark:=#1\do{%
    \expandafter\ifcase\csname X@\mytmark\endcsname\or$^{\star}$\or
    $^{,\star\star}$\fi
  }%
}

\def\tnotemark[#1]{\writemarks{title}{#1}}
     
\let\@tnotes\@empty
\newcounter{tnote}
\def\tnotetext[#1]#2{%
    \expandafter\ifcat\@car#1\@nil a\relax
     \aram{[tnote] [alpha]}%
     \g@addto@macro\@tnotes{%
     \refstepcounter{tnote}\stmLabel{#1}%
     \def\thefootnote{\ifcase\c@tnote\or$\star$\or$\star\star$\fi}%
     \footnotetext{#2}}%
   \else
     \g@addto@macro\@tnotes{%
     \@tempcnta=#1\relax%
     \def\thefootnote{\ifcase\@tempcnta\or$\star$\or$\star\star$\fi}%
     \footnotetext{#2}}%
   \fi
}

\let\@nonumnotes\@empty
\def\nonumnote#1{\g@addto@macro\@nonumnotes{%
     \let\thefootnote\relax\footnotetext{#1}}}

\let\sv@footnote\footnote
\newcounter{fnote}
\def\thefnote{\arabic{fnote}}
\def\fnref#1{\let\comma\@empty
    \def\@fnmark{\@for\@@fnmark:=#1\do{%
    \edef\fnotenum{\@ifundefined{X@\@@fnmark}{1}{\stmRef{\@@fnmark}}}%
  \unskip\comma\fnotenum\let\comma,}}%
}
\def\fnmark[#1]{\writemarks{fnau\theau@}{#1}}

\let\@fnotes\@empty\let\@fnmark\@empty
\def\fntext[#1]#2{%
    \expandafter\ifcat\@car#1\@nil a\relax
     \alarm{alpha}%
     \g@addto@macro\@fnotes{%
     \refstepcounter{fnote}\stmLabel{#1}%
     \def\thefootnote{\@arabic\c@fnote}%
     \global\setcounter{footnote}{\c@fnote}%
     \footnotetext{#2}}%
    \else
     \alarm{number}%
     \global\setcounter{footnote}{#1}%
     \g@addto@macro\@fnotes{%
     \def\thefootnote{\@arabic#1}%
     \footnotetext{#2}}%
    \fi
}

\newif\if@cormark \@cormarkfalse
\def\cormark[#1]{\@cormarktrue
  \writemarks{corau\theau@}{#1}}

\let\@cormark\@empty
\let\@cornotes\@empty
\newcounter{cnote}

\def\cortext[#1]#2{%
    \expandafter\ifcat\@car#1\@nil a\relax
    \alarm{alpha}%
     \g@addto@macro\@cornotes{%
     \refstepcounter{cnote}\stmLabel{#1}%
     \def\thefootnote{\ifcase\thecnote\or$\ast$\or
      $\ast\ast$\or\sep$\ast\ast\ast$\fi}%
     \footnotetext{#2}}%
    \else
    \alarm{number}%
     \g@addto@macro\@cornotes{%
     \@tempcnta=#1\relax
     \def\thefootnote{\ifcase\@tempcnta\or$\ast$\or
      $\ast\ast$\or$\ast\ast\ast$\fi}%
     \footnotetext{#2}}%
    \fi
}

\let\stm@corref\@empty
\def\corref#1{\edef\cnotenum{\stmRef{#1}}%
    \edef\stm@corref{\ifcase\cnotenum\or
         $\ast$\or$\ast\ast$\or$\ast\ast\ast$\fi\hskip-1pt}}

\def\resetTitleCounters{\c@cnote=0
   \c@fnote=0 \c@tnote=0 \c@footnote=0}

\let\eadsep\@empty
\let\uadsep\@empty
\def\@elseads{}
\let\@stmuads\@empty
\let\@cormark\@empty
\def\hashchar{\expandafter\@gobble\string\~}
\def\underscorechar{\expandafter\@gobble\string\_}
\def\lbracechar{\expandafter\@gobble\string\{}
\def\rbracechar{\expandafter\@gobble\string\}}

\gdef\ead{\@ifnextchar[{\@uad}{\@ead}}
\gdef\@ead#1{\bgroup
   \def\_{\underscorechar}%
   \def\{{\lbracechar}%
   \def~{\hashchar}%
   \def\}{\rbracechar}%
   \edef\tmp{\the\@ead}%
   \immediate\write\@auxout{\string\emailauthor
     {#1}{\expandafter\strip@prefix\meaning\tmp}}%
   \if@cormark\global\@cormarkfalse\gdef\@contact{#1}\fi
   \egroup
}
\newcounter{ead}
\def\Hampchr{\HCode{\expandafter\@gobble\string\&}}
\gdef\emailauthor#1#2{\stepcounter{ead}%
    \ifhtml
     \g@addto@macro\@elseads{\raggedright%
      \let\corref\@gobble\def\@@tmp{#1}\eadsep
      \HCode{<a href="}%
       {mailto:\ttfamily\expandafter\strip@prefix\meaning\@@tmp}%
      \HCode{">}% 
       {\ttfamily\Hampchr lt;%
         \expandafter\strip@prefix\meaning\@@tmp\Hampchr gt;}%
      \HCode{</a>}%
      \space  
     (#2)\def\eadsep{\unskip;\space}}%
    \else
     \g@addto@macro\@elseads{\raggedright%
      \let\corref\@gobble\def\@@tmp{#1}\eadsep
       {\ttfamily\expandafter\strip@prefix\meaning\@@tmp}%
     \space(#2)\def\eadsep{\unskip;\space}}%
    \fi
}
\gdef\@uad[#1]#2{\bgroup
   \def~{\hashchar}%
   \def\_{\underscorechar}%
   \def~{\hashchar}%
   \def\}{\rbracechar}%
   \edef\tmp{\the\@eadauthor}
   \immediate\write\@auxout{\string\urlauthor
     {#2}{\expandafter\strip@prefix\meaning\tmp}}%
  \egroup
}
\gdef\urlauthor#1#2{\ifhtml
     \g@addto@macro\@stmuads{\let\corref\@gobble%
      \def\@@tmp{#1}\raggedright\uadsep
      \HCode{<a href="}%
      {\ttfamily\expandafter\strip@prefix\meaning\@@tmp}%
      \HCode{">}% 
      {\ttfamily\Hampchr lt;\expandafter
        \strip@prefix\meaning\@@tmp\Hampchr gt;}%
      \HCode{</a>}% 
      \space(#2)\def\uadsep{\unskip;\space}}%
     \else
      \g@addto@macro\@stmuads{\let\corref\@gobble%
       \def\@@tmp{#1}\raggedright\uadsep
       {\ttfamily\expandafter\strip@prefix\meaning\@@tmp}%
       \space(#2)\def\uadsep{\unskip;\space}}%
     \fi
}

\def\stmauthors{}
\def\useauthors{}

\def\pprinttitle{}
\let\authorsep\@empty
\let\sep\@empty
\def\@exp{\expandafter\expandafter\expandafter}
\def\process@marks{%
      \@ifundefined{mark@address\thestmauthor}{\ignorespaces}%
        {\xdef\@tmp{\@nameuse{mark@address\thestmauthor}}%
          \let\comma\@empty
          \@for\p@mark:=\@tmp\do{%
           \comma{\itshape\@alph\p@mark}\let\comma=,}%
         \def\sep{\unskip,}}
      \@ifundefined{mark@corau\thestmauthor}{\ignorespaces}%
        {\edef\@tmp{\csname mark@corau\thestmauthor\endcsname}%
          \unskip\ifcase\@tmp\or\sep$\ast$\or
           \sep$\ast\ast$\or\sep$\ast\ast\ast$\fi
           \def\sep{\unskip,}}%
      \@ifundefined{mark@fnau\thestmauthor}{\ignorespaces}%
        {\unskip\let\comma\@empty
          \edef\@@tmp{\csname mark@fnau\thestmauthor\endcsname}%
          \sep\@for\p@mark:=\@@tmp\do{%
           \comma{\p@mark}\let\comma=,}%
         \def\sep{\unskip,}}%
}
\newcounter{stmauthor}
\newcounter{au@}
\def\author{\stepcounter{au@}\@ifnextchar[{\@@author}{\@author}}

\newtoks\@eadauthor
\def\@@author[#1]#2{%
   \expandafter\ifcat\@car#1\@nil a\relax
    \g@addto@macro\stmauthors{%
      \def\baselinestretch{1}\stepcounter{stmauthor}%
      \authorsep#2\unskip\textsuperscript{%#1%
       \@for\@@affmark:=#1\do{%
       \edef\affnum{\@ifundefined{X@\@@affmark}{1}{\stmRef{\@@affmark}}}%
      \unskip\sep\affnum\let\sep=,}%
      \ifx\@fnmark\@empty\else\unskip\sep\@fnmark\let\sep=,\fi
      \ifx\stm@corref\@empty\else\unskip\sep\stm@corref\let\sep=,\fi
      \gdef\authorsep{\unskip,\space}%
      \global\let\sep\@empty\global\let\stm@corref\@empty
      \global\let\@fnmark\@empty}%
       }%
   \else
     \writemarks{address\theau@}{#1}
     \g@addto@macro\stmauthors{%
       \def\baselinestretch{1}\stepcounter{stmauthor}%
       \authorsep#2\unskip\textsuperscript{\process@marks}%
       \gdef\authorsep{\unskip,\space}%
       \global\let\sep\@empty\global\let\stm@corref\@empty
    \global\let\@fnmark\@empty%
     }%
   \fi
    \@eadauthor={#2}%
    \g@addto@macro\useauthors{#2; }%
}

\def\@author#1{\g@addto@macro\stmauthors{\normalsize%
    \def\baselinestretch{1}\stepcounter{stmauthor}%
    \upshape\authorsep#1\unskip\textsuperscript{%
      \ifx\@fnmark\@empty\else\unskip\sep\@fnmark\let\sep=,\fi
      \ifx\stm@corref\@empty\else\unskip\sep\stm@corref\let\sep=,\fi
      \process@marks
      }%
    \def\authorsep{\unskip,\space}%
    \global\let\@fnmark\@empty
    \global\let\stm@corref\@empty    \global\let\sep\@empty}%
    \@eadauthor={#1}%
    \g@addto@macro\useauthors{#1; }%
}

\AtBeginDocument{%
  \@ifpackageloaded{hyperref}{%
    \expandafter\gdef\csname Hy@title\endcsname{\usestmtitle}%
    \expandafter\gdef\csname Hy@author\endcsname{\useauthors}%
   }{}
}

\def\stmaddress{}
\def\addsep{\par\vskip6pt}
\def\address{\@ifnextchar[{\@@address}{\@address}}

\def\@alph#1{%
  \ifcase#1\or a\or b\or c\or d\or e\or f\or g\or h\or i\or j\or k\or
  l\or m\or n\or o\or p\or q\or r\or s\or t\or u\or v\or w\or x\or
  y\or z%
  \or aa\or ab\or ac\or ad\or ae\or af\or ag\or ah\or ai\or aj\or
  ak\or al\or am\or an\or ao\or ap\or aq\or ar\or as\or at\or au\or
  av\or aw\or ax\or ay\or az%
  \or ba\or bb\or bc\or bd\or be\or bf\or bg\or bh\or bi\or bj\or
  bk\or bl\or bm\or bn\or bo\or bp\or bq\or br\or bs\or bt\or bu\or
  bv\or bw\or bx\or by\or bz%
  \or ca\or cb\or cc\or cd\or ce\or cf\or cg\or ch\or ci\or cj\or
  ck\or cl\or cm\or cn\or co\or cp\or cq\or cr\or cs\or ct\or cu\or
  cv\or cw\or cx\or cy\or cz%
  \or da\or db\or dc\or dd\or de\or df\or dg\or dh\or di\or dj\or
  dk\or dl\or dm\or dn\or do\or dp\or dq\or dr\or ds\or dt\or du\or
  dv\or dw\or dx\or dy\or dz%
  \or ea\or eb\or ec\or ed\or ee\or ef\or eg\or eh\or ei\or ej\or
  ek\or el\or em\or en\or eo\or ep\or eq\or er\or es\or et\or eu\or
  ev\or ew\or ex\or ey\or ez%
  \or fa\or fb\or fc\or fd\or fe\or ff\or fg\or fh\or fi\or fj\or
  fk\or fl\or fm\or fn\or fo\or fp\or fq\or fr\or fs\or ft\or fu\or
  fv\or fw\or fx\or fy\or fz%
  \or ga\or gb\or gc\or gd\or ge\or gf\or gg\or gh\or gi\or gj\or
  gk\or gl\or gm\or gn\or go\or gp\or gq\or gr\or gs\or gt\or gu\or
  gv\or gw\or gx\or gy\or gz%
  \else\@ctrerr\fi}

\newcounter{affn}
\renewcommand\theaffn{\alph{affn}}

\long\def\@@address[#1]#2{%
   \expandafter\ifcat\@car#1\@nil a\relax
    \g@addto@macro\stmaddress{%
     \def\baselinestretch{1}%
     \refstepcounter{affn}
     \xdef\@currentlabel{\theaffn}
     \stmLabel{#1}%
     \ifnum\jtype>5
     \def\thefootnote{\itshape\theaffn}%
     \footnotetext{#2}%
     \else
      \textsuperscript{\itshape\theaffn}#2\par%
     \fi}%
   \else
    \g@addto@macro\stmaddress{%
     \def\baselinestretch{1}%
     \setcounter{affn}{#1}%
     \ifnum\jtype>5
      \def\thefootnote{\itshape\theaffn}%
      \footnotetext{#2}%
     \else
      \textsuperscript{\itshape\theaffn}#2\par%
     \fi}%
   \fi
} 

\long\def\@address#1{\ifnum\jtype<6
    \g@addto@macro\stmauthors{%
      \def\baselinestretch{1}%
      \addsep\footnotesize\itshape#1\def\addsep{\par\vskip6pt}%
      \def\authorsep{\par\vskip8pt}}%
    \else
    \g@addto@macro\stmaddress{%
      \def\baselinestretch{1}%
      \addsep\footnotesize\itshape#1\def\addsep{\par\vskip6pt}%
      \def\authorsep{\par\vskip8pt}}%
    \fi
}

\def\received#1{\gdef\@received{#1}}
\def\accepted#1{\gdef\@accepted{#1}}
\let\@received\@empty
\let\@accepted\@empty

\newbox\absbox
\def\abstitle[#1]{\abstracttitle{#1}}
\let\@stmabstitle\@empty %*%
\def\abstracttitle#1{%
  \ifhtml\gdef\@stmabstitle{%
    \Tg<span class="abshead">#1: \Tg</span>}\else
  \gdef\@stmabstitle{#1}\fi} %
\abstracttitle{Abstract} %*%
\renewenvironment{abstract}{\global\setbox\absbox=\vbox\bgroup
  \hsize=\textwidth\def\baselinestretch{1}%
  \noindent\unskip\textbf{\@stmabstitle} %*%
 \par\medskip\noindent\unskip\ignorespaces}
 {\egroup}

\newenvironment{query}[1]{\setbox0=\vbox\bgroup}{\egroup}

\def\kwdtitle[#1]{\keywordtitle{#1}}
\newbox\keybox
\let\@stmkwdtitle\@empty %*%
\def\keywordtitle#1{\gdef\@stmkwdtitle{#1}} %*%
\def\keywordtitlesep#1{\gdef\@stmkeywordtitlesep{#1}} %*%
\keywordtitle{Keywords} %*%
\keywordtitlesep{:\ }
\def\keyword{%
  \def\sep{\unskip, }%
 \def\MSC{\@ifnextchar[{\@MSC}{\@MSC[2000]}}
  \def\@MSC[##1]{\par\leavevmode\hbox {\it ##1~MSC:\space}}%
  \def\PACS{\par\leavevmode\hbox {\it PACS:\space}}%
  \def\JEL{\par\leavevmode\hbox {\it JEL:\space}}%
  \global\setbox\keybox=\vbox\bgroup\hsize=\textwidth
  \normalsize\normalfont\def\baselinestretch{1}
  \parskip\z@
  \noindent\textit{\@stmkwdtitle\@stmkeywordtitlesep}
  \raggedright                         % Keywords are not justified.
  \ignorespaces}
\def\endkeyword{\par \egroup}

\newdimen\Columnwidth
\Columnwidth=\columnwidth

\def\printFirstPageNotes{\if@screen\color{botcolor}\fi%
  \iflongmktitle
   \let\columnwidth=\textwidth
  \fi
   \ifnum\jtype>5 \relax
     \ifx\stmaddress\@empty\else
     \stmaddress\fi
   \fi
  \ifx\@tnotes\@empty\else\@tnotes\fi
  \ifx\@nonumnotes\@empty\else\@nonumnotes\fi
  \ifx\@cornotes\@empty\else\@cornotes\fi
  \ifx\@elseads\@empty\relax\else
  \let\thefootnote\relax
  \footnotetext{\ifnum\theead=1\relax
    \textit{Email address:\space}\else
    \textit{Email addresses:\space}\fi
    \@elseads}\fi
  \ifx\@stmuads\@empty\relax\else
  \let\thefootnote\relax
  \footnotetext{\textit{URL:\space}%
    \@stmuads}\fi
  \ifx\@fnotes\@empty\else\@fnotes\fi
  \iflongmktitle\if@twocolumn
    \let\columnwidth=\Columnwidth
   \fi
  \fi
  \normalcolor
}

%% Pushing text to begin on newpage %*%
\def\newpage@after@title{title}
\def\newpage@after@author{author}
\def\newpage@after@abstract{abstract}
\def\newpageafter#1%
    {\gdef\@stmnewpageafter{#1}}

\long\def\pprintMaketitle{\clearpage
%  \iflongmktitle\if@twocolumn\let\columnwidth=\textwidth\fi\fi
  \resetTitleCounters
  \def\baselinestretch{1}%
  \printFirstPageNotes
  \begin{\stmtitlealign}%
 \thispagestyle{pprintTitle}%
   \def\baselinestretch{1}%
    \Large\@title\par\vskip18pt%
    \ifx\@stmnewpageafter\newpage@after@title% %*%
      \newpage
    \fi%
    \normalsize\stmauthors\par\vskip10pt
    \footnotesize\itshape\stmaddress\par\vskip36pt
    \ifx\@stmnewpageafter\newpage@after@author% %*%
      \newpage
    \fi%
    \edef\@tmp{0}%
    \ifvoid\absbox\edef\@tmp{0}\else\edef\@tmp{1}%
    \alarm{ Abstract Box is not Empty}\fi
    \ifvoid\keybox\edef\@tmp{0}\else\edef\@tmp{1}%
    \alarm{ Abstract Box is not Empty}\fi
    \ifcase\@tmp\or\hrule\vskip12pt\fi
    \ifvoid\absbox\else\unvbox\absbox\par\vskip10pt\fi
    \ifvoid\keybox\else\unvbox\keybox\par\vskip10pt\fi
    \ifcase\@tmp\or\hrule\vskip12pt\fi
    \ifx\@stmnewpageafter\newpage@after@abstract% %*%
      \newpage
    \fi%
    \end{\stmtitlealign}%
    \setcounter{footnote}{\c@fnote}%
    \gdef\thefootnote{\arabic{footnote}}%
    \def\baselinestretch{\@blstr}%
  }

\def\printWarning{%
     \mbox{}\par\vfill\par\bgroup
     \fboxsep12pt\fboxrule1pt
     \hspace*{.18\textwidth}
     \fcolorbox{gray50}{gray10}{\box\warnbox}
     \egroup\par\vfill\thispagestyle{empty}
     \setcounter{page}{0}
     \clearpage}

\long\def\finalMaketitle{%
  \resetTitleCounters
  \def\baselinestretch{1}%
   \MaketitleBox
   \thispagestyle{pprintTitle}%
  \gdef\thefootnote{\arabic{footnote}}%
  }

\long\def\MaketitleBox{%
  \resetTitleCounters
  \def\baselinestretch{1}%
  \begin{\stmtitlealign}%
   \def\baselinestretch{1}%
    \Large\@title\par\vskip18pt
    \normalsize\stmauthors\par\vskip10pt
    \footnotesize\itshape\stmaddress\par\vskip36pt
    \edef\@tmp{0}%
    \ifvoid\absbox\edef\@tmp{0}\else\edef\@tmp{1}%
    \alarm{ Abstract Box is not Empty}\fi
    \ifvoid\keybox\edef\@tmp{0}\else\edef\@tmp{1}%
    \alarm{ Abstract Box is not Empty}\fi
    \ifcase\@tmp\or\hrule\vskip12pt\fi
    \ifvoid\absbox\else\unvbox\absbox\par\vskip10pt\fi
    \ifvoid\keybox\else\unvbox\keybox\par\vskip10pt\fi
    \ifcase\@tmp\or\hrule\vskip12pt\fi
    \end{\stmtitlealign}%
  }

\def\FNtext#1{\par\bgroup\footnotesize#1\egroup}
\newdimen\space@left
\long\def\getSpaceLeft{%\global\@twocolumnfalse%
   \global\setbox0=\vbox{\hsize=\textwidth\MaketitleBox}%
   \global\setbox1=\vbox{\hsize=\textwidth
    \let\footnotetext\FNtext
    \printFirstPageNotes}%
    \xdef\noteheight{\the\ht1}%
    \xdef\titleheight{\the\ht0}%
    \@tempdima=\vsize
    \advance\@tempdima-\noteheight
    \advance\@tempdima-1\baselineskip
}

\skip\footins=24pt

\newbox\stm@boxa
\newbox\stm@boxb

\ifpreprint
  \def\maketitle{\pprintMaketitle}
  \else
   \ifnum\jtype=1
    \def\maketitle{%
      \iflongmktitle\getSpaceLeft
       \global\setbox\stm@boxa=\vsplit0 to \@tempdima
       \unvbox\stm@boxa\par\resetTitleCounters
       \thispagestyle{\fistpagestyle}%
       \printFirstPageNotes
       \unvbox0%
      \else
       \finalMaketitle\printFirstPageNotes
      \fi
    \gdef\thefootnote{\arabic{footnote}}}%
  \else
 \ifnum\jtype=5
    \def\maketitle{%
      \iflongmktitle\getSpaceLeft
       \global\setbox\stm@boxa=\vsplit0 to \@tempdima
       \box\stm@boxa\par\resetTitleCounters
       \thispagestyle{\fistpagestyle}%
       \printFirstPageNotes
       \twocolumn[\box0]%\printFirstPageNotes
      \else
       \twocolumn[\finalMaketitle]\printFirstPageNotes
     \fi
     \gdef\thefootnote{\arabic{footnote}}}
  \else
  \if@twocolumn
    \def\maketitle{%
      \iflongmktitle\getSpaceLeft
       \global\setbox\stm@boxa=\vsplit0 to \@tempdima
       \box\stm@boxa\par\resetTitleCounters
       \thispagestyle{\fistpagestyle}%
       \printFirstPageNotes
       \twocolumn[\box0]%
      \else
       \twocolumn[\finalMaketitle]\printFirstPageNotes
      \fi
     \gdef\thefootnote{\arabic{footnote}}}%
   \else
    \def\maketitle{%
      \iflongmktitle\getSpaceLeft
       \global\setbox\stm@boxa=\vsplit0 to \@tempdima
       \box\stm@boxa\par\resetTitleCounters
       \thispagestyle{\fistpagestyle}%
       \printFirstPageNotes
       \box0%
     \else
       \finalMaketitle\printFirstPageNotes
      \fi
    \gdef\thefootnote{\arabic{footnote}}}%
   \fi
  \fi
 \fi
\fi

\let\@stmmyfooter\@empty
\let\@stmmyfooteralign\@empty
\def\@stmmyfooteralignleft{L}
\def\@stmmyfooteralignright{R}
\def\@stmmyfooteraligncenter{C}

\def\myfooter[#1]#2 %*%
      {\gdef\@stmmyfooteralign{#1}
       \gdef\@stmmyfooter{#2}}

\def\myfooterfont#1{\gdef\@myfooterfont{#1}}
\myfooterfont{\footnotesize\itshape}
\def\firstpagestyle{pprintTitle}
\def\ps@pprintTitle{%
     \let\@oddhead\@empty
     \let\@evenhead\@empty
     \def\@oddfoot
       {\hbox to \textwidth%
        {\ifnopreprintline\relax\else
        \@myfooterfont%
         \ifx\@stmmyfooteralign\@stmmyfooteraligncenter%
           \hfil\@stmmyfooter\hfil%
         \else%
         \ifx\@stmmyfooteralign\@stmmyfooteralignleft%
           \@stmmyfooter\hfill{}%
         \else%
         \ifx\@stmmyfooteralign\@stmmyfooteralignright%
           {}\hfill\@stmmyfooter%
         \else%
               Preprint submitted to \ifx\@journal\@empty%
                 Sayahna%
            \else\@journal\fi
            \ifx\@date\@empty\else\hfill\@date\fi\fi%
         \fi%
         \fi%
         \fi%
         }
       }%
     \let\@evenfoot\@oddfoot}
\def\ps@stm{%
     \def\@oddhead{\hbox to \textwidth%
       {\@myfooterfont
         \ifx\@recto\@empty\relax\else
         \hfill\@recto\hfill
         \fi%
       }%
     }%
     \def\@evenhead{\hbox to \textwidth%
       {\@myfooterfont
         \ifx\@verso\@empty\relax\else
         \hfill\@verso\hfill
         \fi%
       }%
     }%
     \def\@oddfoot
       {\hbox to \textwidth%
        {\ifnopreprintline\relax\else
        \@myfooterfont%
         \ifx\@stmmyfooteralign\@stmmyfooteraligncenter%
           \hfil\@stmmyfooter\hfil%
         \else%
         \ifx\@stmmyfooteralign\@stmmyfooteralignleft%
           \@stmmyfooter\hfill{}%
         \else%
         \ifx\@stmmyfooteralign\@stmmyfooteralignright%
           {}\hfill\@stmmyfooter%
         \else%
               Preprint submitted to \ifx\@journal\@empty%
                 Sayahna%
            \else\@journal\fi
            \hfill{\upshape\thepage}\hfill
            \ifx\@date\@empty\today
             \else\hfill\@date
            \fi
            \fi%
         \fi%
         \fi%
         \fi%
         \hskip-3pt}%
       }%
     \let\@evenfoot\@oddfoot}
\ifnum\jtype<6
  \ps@stm
\fi
\def\@seccntDot{.}
\def\@seccntformat#1{\csname the#1\endcsname\@seccntDot\hskip 0.5em}

\renewcommand\section{\@startsection {section}{1}{\z@}%
           {-18\p@ \@plus 6\p@ \@minus 3\p@}%
           {9\p@ \@plus 6\p@ \@minus 3\p@}%
           {\normalsize\bfseries\boldmath}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
           {-12\p@ \@plus 6\p@ \@minus 3\p@}%
           {3\p@ \@plus 6\p@ \@minus 3\p@}%
           {\normalfont\normalsize\itshape}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
           {-12\p@ \@plus 6\p@ \@minus 3\p@}%
           {\p@}%
           {\normalfont\normalsize\itshape}}

\def\paragraph{\secdef{\stm@aparagraph}{\stm@bparagraph}}
\def\stm@aparagraph[#1]#2{\stmparagraph[#1]{#2.}}
\def\stm@bparagraph#1{\stmparagraph*{#1.}}

\newcommand\stmparagraph{\@startsection{paragraph}{4}{0\z@}%
           {10\p@ \@plus 6\p@ \@minus 3\p@}%
           {-6\p@}%
           {\normalfont\itshape}}
%
% Enum macros
% 
\if@noenum\relax\else
 \newdimen\leftMargin
 \leftMargin=2em
 \newtoks\@enLab  %\newtoks\@enfont
 \def\@enQmark{?}
 \def\@enLabel#1#2{%
   \edef\@enThe{\noexpand#1{\@enumctr}}%
   \@enLab\expandafter{\the\@enLab\csname the\@enumctr\endcsname}%
   \@enloop}
 \def\@enSpace{\afterassignment\@enSp@ce\let\@tempa= }
 \def\@enSp@ce{\@enLab\expandafter{\the\@enLab\space}\@enloop}
 \def\@enGroup#1{\@enLab\expandafter{\the\@enLab{#1}}\@enloop}
 \def\@enOther#1{\@enLab\expandafter{\the\@enLab#1}\@enloop}
 \def\@enloop{\futurelet\@entemp\@enloop@}
 \def\@enloop@{%
   \ifx A\@entemp         \def\@tempa{\@enLabel\Alph  }\else
   \ifx a\@entemp         \def\@tempa{\@enLabel\alph  }\else
   \ifx i\@entemp         \def\@tempa{\@enLabel\roman }\else
   \ifx I\@entemp         \def\@tempa{\@enLabel\Roman }\else
   \ifx 1\@entemp         \def\@tempa{\@enLabel\arabic}\else
   \ifx \@sptoken\@entemp \let\@tempa\@enSpace         \else
   \ifx \bgroup\@entemp   \let\@tempa\@enGroup         \else
   \ifx \@enum@\@entemp   \let\@tempa\@gobble          \else
                          \let\@tempa\@enOther
                          \fi\fi\fi\fi\fi\fi\fi\fi
                          \@tempa}
 \newlength{\@sep} \newlength{\@@sep}
 \setlength{\@sep}{.5\baselineskip plus.2\baselineskip
   minus.2\baselineskip}
 \setlength{\@@sep}{.1\baselineskip plus.01\baselineskip
   minus.05\baselineskip}
 \providecommand{\sfbc}{\rmfamily\upshape}
 \providecommand{\sfn}{\rmfamily\upshape}
 \def\@enfont{\ifnum \@enumdepth >1\let\@nxt\sfn \else\let\@nxt\sfbc \fi\@nxt}
 \def\enumerate{%
   \ifnum \@enumdepth >3 \@toodeep\else
   \advance\@enumdepth \@ne
   \edef\@enumctr{enum\romannumeral\the\@enumdepth}\fi
   \@ifnextchar[{\@@enum@}{\@enum@}}
 \def\@@enum@[#1]{%
   \@enLab{}\let\@enThe\@enQmark
   \@enloop#1\@enum@
   \ifx\@enThe\@enQmark\@warning{The counter will not be printed.%
     ^^J\space\@spaces\@spaces\@spaces The label is: \the\@enLab}\fi
   \expandafter\edef\csname label\@enumctr\endcsname{\the\@enLab}%
   \expandafter\let\csname the\@enumctr\endcsname\@enThe
   \csname c@\@enumctr\endcsname7
   \expandafter\settowidth
   \csname leftmargin\romannumeral\@enumdepth\endcsname
   {\the\@enLab\hskip\labelsep}%
   \@enum@}
 \def\@enum@{\list{{\@enfont\csname label\@enumctr\endcsname}}%
   {\usecounter{\@enumctr}\def\makelabel##1{\hss\llap{##1}}%
     \ifnum \@enumdepth>1\setlength{\topsep}{\@@sep}\else
     \setlength{\topsep}{\@sep}\fi
     \ifnum \@enumdepth>1\setlength{\itemsep}{0pt plus1pt minus1pt}%
     \else \setlength{\itemsep}{\@@sep}\fi
     % \setlength\leftmargin{\leftMargin}%%%{1.8em}
     \setlength{\parsep}{0pt plus1pt minus1pt}%
     \setlength{\parskip}{0pt plus1pt minus1pt}%
   }%
 }

 \def\endenumerate{\ifnum \@enumdepth >1\addvspace{\@@sep}\else
           \addvspace{\@sep}\fi \endlist}
 \def\sitem{\@noitemargtrue\@item[\@itemlabel *]}
 \def\itemize{\@ifnextchar[{\@Itemize}{\@Itemize[]}}
 \def\@Itemize[#1]{\def\next{#1}%
  \ifnum \@itemdepth >\thr@@\@toodeep\else
   \advance\@itemdepth\@ne
  \ifx\next\@empty\else\expandafter\def\csname
   labelitem\romannumeral\the\@itemdepth\endcsname{#1}\fi%
  \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
  \expandafter\list\csname\@itemitem\endcsname
  {\def\makelabel##1{\hss\llap{##1}}}%
 \fi}
\fi % ---> end of \if@noenum
%
%
% Theorem macros
%
%
 \def\headcolor{\if@screen\color{seccolor}\else\normalcolor\fi}
 \def\newdefinition#1{%
  \@ifnextchar[{\@odfn{#1}}{\@ndfn{#1}}}%]
 \def\@ndfn#1#2{%
  \@ifnextchar[{\@xndfn{#1}{#2}}{\@yndfn{#1}{#2}}}
 \def\@xndfn#1#2[#3]{%
  \expandafter\@ifdefinable\csname #1\endcsname
    {\@definecounter{#1}\@newctr{#1}[#3]%
     \expandafter\xdef\csname the#1\endcsname{%
       \expandafter\noexpand\csname the#3\endcsname \@dfncountersep
          \@dfncounter{#1}}%
     \global\@namedef{#1}{\@dfn{#1}{#2}}%
     \global\@namedef{end#1}{\@enddefinition}}}
 \def\@yndfn#1#2{%
  \expandafter\@ifdefinable\csname #1\endcsname
    {\@definecounter{#1}%
     \expandafter\xdef\csname the#1\endcsname{\@dfncounter{#1}}%
     \global\@namedef{#1}{\@dfn{#1}{#2}}%
     \global\@namedef{end#1}{\@enddefinition}}}
 \def\@odfn#1[#2]#3{%
  \@ifundefined{c@#2}{\@nocounterr{#2}}%
    {\expandafter\@ifdefinable\csname #1\endcsname
    {\global\@namedef{the#1}{\@nameuse{the#2}}
  \global\@namedef{#1}{\@dfn{#2}{#3}}%
  \global\@namedef{end#1}{\@enddefinition}}}}
 \def\@dfn#1#2{%
  \refstepcounter{#1}%
  \@ifnextchar[{\@ydfn{#1}{#2}}{\@xdfn{#1}{#2}}}
\def\@xdfn#1#2{%
  \@begindefinition{#2}{\csname the#1\endcsname}\ignorespaces}
\def\@ydfn#1#2[#3]{%
  \@opargbegindefinition{#2}{\csname the#1\endcsname}{#3}\ignorespaces}
\def\@dfncounter#1{\noexpand\arabic{#1}}
\def\@dfncountersep{.}
\def\@begindefinition#1#2{\trivlist
   \item[\hskip\labelsep{\bfseries\headcolor #1\ #2.}]\normalcolor\upshape}
\def\@opargbegindefinition#1#2#3{\trivlist
      \item[\hskip\labelsep{\bfseries\headcolor #1\ #2\ (#3).}]\normalcolor\upshape}
\def\@enddefinition{\endtrivlist}

\def\@begintheorem#1#2{\trivlist
  \let\baselinestretch\@blstr
   \item[\hskip \labelsep{\bfseries\headcolor #1\ #2.}]\normalcolor\itshape}
\def\@opargbegintheorem#1#2#3{\trivlist
  \let\baselinestretch\@blstr
      \item[\hskip \labelsep{\bfseries\headcolor #1\ #2\ (#3).}]\normalcolor\itshape}

\def\newproof#1{\def\baselinestretch{\@blstr}%
  \@ifnextchar[{\@oprf{#1}}{\@nprf{#1}}}
\def\@nprf#1#2{%
  \@ifnextchar[{\@xnprf{#1}{#2}}{\@ynprf{#1}{#2}}}
\def\@xnprf#1#2[#3]{%
  \expandafter\@ifdefinable\csname #1\endcsname
  {\@definecounter{#1}\@newctr{#1}[#3]%
    \expandafter\xdef\csname the#1\endcsname{%
      \expandafter\noexpand\csname the#3\endcsname \@prfcountersep
      \@prfcounter{#1}}%
    \global\@namedef{#1}{\@prf{#1}{#2}}%
    \global\@namedef{end#1}{\@endproof}}}
\def\@ynprf#1#2{%
  \expandafter\@ifdefinable\csname #1\endcsname
  {\@definecounter{#1}%
    \expandafter\xdef\csname the#1\endcsname{\@prfcounter{#1}}%
    \global\@namedef{#1}{\@prf{#1}{#2}}%
    \global\@namedef{end#1}{\@endproof}}}
\def\@oprf#1[#2]#3{%
  \@ifundefined{c@#2}{\@nocounterr{#2}}%
  {\expandafter\@ifdefinable\csname #1\endcsname
    {\global\@namedef{the#1}{\@nameuse{the#2}}%
      \global\@namedef{#1}{\@prf{#2}{#3}}%
      \global\@namedef{end#1}{\@endproof}}}}
\def\@prf#1#2{%
  \refstepcounter{#1}%
  \@ifnextchar[{\@yprf{#1}{#2}}{\@xprf{#1}{#2}}}
\def\@xprf#1#2{%
  \@beginproof{#2}{\csname the#1\endcsname}\ignorespaces}
\def\@yprf#1#2[#3]{%
  \@opargbeginproof{#2}{\csname the#1\endcsname}{#3}\ignorespaces}
\def\@prfcounter#1{\noexpand\arabic{#1}}
\def\@prfcountersep{.}
\def\@beginproof#1#2{\trivlist\let\baselinestretch\@blstr
\item[\hskip \labelsep{\headcolor\scshape #1.}]\normalcolor\rmfamily}
\def\@opargbeginproof#1#2#3{\trivlist\let\baselinestretch\@blstr
\item[\hskip \labelsep{\headcolor\scshape #1\ (#3).}]\normalcolor\rmfamily}
\def\@endproof{\endtrivlist}
\newcommand*{\qed}{\hbox{}\hfill$\Box$}

\@ifundefined{@biboptions}{\xdef\@biboptions{numbers}}{}
\InputIfFileExists{\jobname.spl}{}{}
%DW \ifnonatbib\relax\else
%DW  \RequirePackage[\@biboptions]{natbib}
%DW \fi
\newwrite\splwrite
\immediate\openout\splwrite=\jobname.spl
\def\biboptions#1{\def\next{#1}\immediate\write\splwrite{%
    \string\g@addto@macro\string\@biboptions{%
      ,\expandafter\strip@prefix\meaning\next}}}
%DW \ifnonatbib\relax\else
%DW \@ifundefined{bibsep}{\newdimen\bibsep}{}
%DW \fi
\let\baselinestretch=\@blstr
\ifcase\jtype\or% 1 narrow
 \RequirePackage{geometry}
 \geometry{twoside,
  paperwidth=210mm,
  paperheight=297mm,
  textheight=562pt,
  textwidth=384pt,
  centering,
  headheight=30pt,
  headsep=18pt,
  footskip=24pt,
  footnotesep=24pt plus 2pt minus 12pt,
 }%
%DW \ifnonatbib\relax\else\global\let\bibfont=\footnotesize\fi
%DW \ifnonatbib\relax\else \global\bibsep=0pt\fi
 \global\@twosidetrue
 \if@twocolumn\global\@twocolumnfalse\fi
\or % 2
\or % \jtype=3 standard 
 \RequirePackage{geometry}
 \geometry{twoside,
  paperwidth=210mm,
  paperheight=297mm,
  textheight=622pt,
  textwidth=468pt,
  centering,
  headheight=50pt,
  headsep=18pt,
  footskip=24pt,
  footnotesep=24pt plus 2pt minus 12pt,
  columnsep=2pc
 }%
 \global\let\bibfont=\footnotesize
 \global\bibsep=0pt
 \if@twocolumn\input{fleqn.clo}\fi
\or % 4
\or % \jtype=5 wide option
 \RequirePackage{geometry}
 \geometry{twoside,
  paperwidth=210mm,
  paperheight=297mm,
  textheight=682pt,
  textwidth=522pt,
  centering,
 headheight=50pt,
  headsep=18pt,
  footskip=24pt,
  footnotesep=24pt plus 2pt minus 12pt,
  columnsep=18pt
 }%
 \global\let\bibfont=\footnotesize
 \global\bibsep=0pt
 \input{fleqn.clo}
 \global\@twocolumntrue
\or % \jtype=6 screen option
 \RequirePackage{geometry}
 \geometry{twoside,
  paperheight=210mm,
  paperwidth=297mm,
  textheight=252pt,
  textwidth=682pt,
  centering,
  headheight=50pt,
  headsep=18pt,
  footskip=24pt,
  footnotesep=24pt plus 2pt minus 12pt,
  columnsep=18pt
 }%
 \global\let\bibfont=\footnotesize
 \global\bibsep=0pt
\fi
%%
%% End of option 'screen'
%%
\def\journal#1{\gdef\@journal{#1}}
 \let\@journal\@empty
\newenvironment{frontmatter}{}{\maketitle}

\def\verso#1{\gdef\@verso{#1}}
\def\recto#1{\gdef\@recto{#1}}
\let\@verso\@empty
\let\@recto\@empty

\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip\footnotesize
  \sbox\@tempboxa{#1: #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1: #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

\AtBeginDocument{\@ifpackageloaded{hyperref}
  {\def\@linkcolor{brown}
   \def\@anchorcolor{brown}
   \def\@citecolor{brown}
   \def\@filecolor{brown}
   \def\@urlcolor{brown}
   \def\@menucolor{brown}
   \def\@pagecolor{brown}
\begingroup
  \@makeother\`%
  \@makeother\=%
  \edef\x{%
    \edef\noexpand\x{%
      \endgroup
      \noexpand\toks@{%
        \catcode 96=\noexpand\the\catcode`\noexpand\`\relax
        \catcode 61=\noexpand\the\catcode`\noexpand\=\relax
      }%
    }%
    \noexpand\x
  }%
\x
\@makeother\`
\@makeother\=
}{}}

%
% Consider using \RequirePackage[title]{appendix}
%

\def\appendixname{Appendix }
\renewcommand\appendix{\par
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \setcounter{equation}{0}
  \gdef\thefigure{\@Alph\c@section.\arabic{figure}}%
  \gdef\thetable{\@Alph\c@section.\arabic{table}}%
  \gdef\thesection{\appendixname\space\@Alph\c@section}%
  \@addtoreset{equation}{section}%
  \gdef\theequation{\@Alph\c@section.\arabic{equation}}%
  \addtocontents{toc}{\string\let\string\numberline\string\tmptocnumberline}{}{}
}

%%%% \numberline width calculation for appendix.
\newdimen\appnamewidth
\def\tmptocnumberline#1{%
   \setbox0=\hbox{\appendixname}%
   \appnamewidth=\wd0
   \addtolength\appnamewidth{2.5pc}%
   \hb@xt@\appnamewidth{#1\hfill}%
}

%% Added for work with amsrefs.sty

\@ifpackageloaded{amsrefs}%
  {}
  {%\let\bibsection\relax%
  \AtBeginDocument{\def\cites@b#1#2,#3{%
    \begingroup[%
        \toks@{\InnerCite{#2}#1}%
        \ifx\@empty#3\@xp\@gobble\fi
        \cites@c#3
      }%
    }%
  }

%
% Sundry macros for screen and doc options
% 
\def\textmarker#1#2{\textcolor{#1}{#2}}%*%
\let\screenclearpage\relax
\let\printclearpage\clearpage
\let\docclearpage\relax
%
% Version, contact and date
% 
\def\version#1{\gdef\@version{#1}}
\def\@version{1.0}
\def\contact#1{\gdef\@contact{#1}}
\let\@contact\@empty

%
% Last page is defined
%
\def\LastPage#1{\gdef\@LastPage{#1}}
\def\@LastPage{100}
%
% Boxes defined for top, bottom and side
% 
\newbox\topbox
\newbox\linkbox
\newbox\contbox
%
% Alignment/fonts of title and author names
% 
\def\titlealign#1{\gdef\@titlealign{#1}}
\let\@titlealign\centering
\def\aualign#1{\gdef\@aualign{#1}}
\let\@aualign\centering
\def\titlefont#1{\gdef\@titlefont{#1}}
\def\aufont#1{\gdef\@aufont{#1}}
\def\@titlefont{\fontsize{20}{24}}
\def\@aufont{\fontsize{10}{12}}
%
% Footer font
% 
\def\footerfont#1{\gdef\@footerfont{#1}}
\def\@footerfont{\fontsize{7}{8}}
%
% QLinks font
% 
\def\qlinksfont#1{\gdef\@qlinkfont{#1}}
\def\@qlinkfont{\fontsize{7}{7.8}\fontseries{l}}
\let\qlinkfont\qlinksfont
%
% Sidebar/footer info box
% 
\def\sidebarinfo#1{\gdef\@sidebarinfo{#1}}
\let\@sidebarinfo\@empty
\def\footerinfo#1{\gdef\@footerinfo{#1}}
\let\@footerinfo\@empty
%
% Footer address
% 
\def\footeraddress#1{\gdef\@footeraddress{#1}}
\let\@footeraddress\@empty
%
% Load stm-talk.sty if the journal type is greater than 5
% 
\ifnum\jtype>5
 \RequirePackage{stm-talk}
\fi
\if@screen
  \let\screenclearpage\clearpage
 \let\printclearpage\relax
\fi
\if@doc
  \let\docclearpage\clearpage
 \let\printclearpage\relax
\fi

%
% Font loading
%

% \DeclareOption{cmr}{\setcounter{jfont}{0}}
% \DeclareOption{antt}{\setcounter{jfont}{1}}
% \DeclareOption{arev}{\setcounter{jfont}{2}}
% \DeclareOption{charter}{\setcounter{jfont}{3}}
% \DeclareOption{fouriernc}{\setcounter{jfont}{4}}
% \DeclareOption{fourier}{\setcounter{jfont}{5}}
% \DeclareOption{garamond}{\setcounter{jfont}{6}}
% \DeclareOption{kerkis}{\setcounter{jfont}{7}}
% \DeclareOption{kurier}{\setcounter{jfont}{8}}
% \DeclareOption{mathpazo}{\setcounter{jfont}{9}}
% \DeclareOption{mathpple}{\setcounter{jfont}{10}}
% \DeclareOption{palatino}{\setcounter{jfont}{11}}
% \DeclareOption{sspro}{\setcounter{jfont}{12}}
% \DeclareOption{times}{\setcounter{jfont}{13}}
% \DeclareOption{utopia}{\setcounter{jfont}{14}}
% \usepackage[T1]{fontenc}

\def\fontoptions#1{\gdef\stm@fontoptions{#1}}
\let\stm@fontoptions\@empty
\newcommand\getpackage[2][]{\fontoptions{#1}%
  \ifhtml\relax\else
   \IfFileExists{#2.sty}%
    {\RequirePackage[\stm@fontoptions]{#2}}%
    {\alarm{Font package "#2" is not installed in your system}}%
  \fi
} 

\ifcase\c@jfont % = 0 cmr will be loaded by default
  \or % = 1
   \getpackage[math,light,condensed]{anttor}
  \or % = 2
   \getpackage[]{arev} % Arev sans font and arev math
  \or % = 3
   \getpackage[charter]{mathdesign}
  \or % = 4 
   \getpackage[]{fouriernc} % NewCenturySchoolBook
  \or % = 5
   \getpackage[]{fourier} % Fourier-GUTenberg Utopia 
  \or % = 6
   \getpackage[garamond]{mathdesign}
  \or % = 7
   \getpackage[]{txfonts}
   \getpackage[]{kerkis} % Kerkis font + txfonts math
  \or % = 8
   \getpackage[light,math]{kurier}
  \or % = 9
   \getpackage[osf,sc]{mathpazo} % Palatino (scaling possible)
  \or % = 10
   \getpackage[]{mathpple} % URW Palatino
  \or % = 11
   \getpackage[]{pxfonts} % palatino + math
  \or % = 12
   \getpackage[oldstyle,semibold,regular,default]{sourcesanspro}
  \or % = 13
   \getpackage[]{txfonts}
  \or % = 14
   \getpackage[utopia]{mathdesign}
 \fi

\ifnum\jtype<7 \let\dummysection\relax\fi
\endinput
%%
%% End of file `stm.cls'.
